<?php

namespace App\Http\Controllers\Site\Student\QuickUpdate;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\SubjectCondition;
use App\Models\BloodGroup\BloodGroup;
use App\Models\Country\Country;
use App\Models\District\District;
use App\Models\Division\Division;
use App\Models\Gender\Gender;
use App\Models\Religion\Religion;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\Thana\Thana;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Image\Photo;
use App\Models\SubjectGroupConditionSetting\SiteSubjectConditionLimit;
use App\Models\Academic\AcademicSession;
use App\Models\House\House;
use Response;
use Session;
use Image;
use Carbon\Carbon;

use PDF;

class SiteStudentQuickUpdateController extends ProjectController
{

    private $carbon_now;
    private $studentHistory;
    public function __construct(StudentHistory $studentHistory)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->carbon_now = Carbon::now();
        $this->studentHistory = $studentHistory;

    }


    public function index()
    {
        $viewType = 'Student Form Quick Update';
        return view('default.admin.layouts.master', compact('viewType'));

    }


    private function classGroupSectionValidation($request){

        $check_group_section=SiteShiftClassGroupSectionSetting::
        where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->first();


        if($check_group_section->academic_department_id && !$request->academic_department_id){
            return Response::json(['message' => 'Plese Select Department!', 'mode' => 'Error'], 200);
        }

//        if($check_group_section->academic_class_group_id && !$request->academic_class_group_id){
//            return Response::json(['message' => 'Plese Select Group!', 'mode' => 'Error'], 200);
//        }
//
//        if($check_group_section->academic_section_ids && !$request->academic_section_id){
//            return Response::json(['message' => 'Plese Select Section!', 'mode' => 'Error'], 200);
//        }

    }


    public function getStudentForRollRegistrationQuickUpdate(Request $request){

        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){

            return $valiedation;
        }

        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id');
        },'session'])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix',
                'registration_no', 'board_registration_number', 'board_roll_number','academic_session_id','house_id')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();

            $siteInfo=SiteInfo::where('id',Session::get('SITE_ID'))->first();

           $session_list= AcademicSession::get();
           $house_ids = explode(',', $siteInfo->house_ids);

           $house_list = House::whereIn('id',$house_ids)->where('status',true)->get();

        return [$student_list,$session_list,$house_list];
    }


    public function quickUpdateRollRegistration(Request $request){

        $StudentList=collect($request->StudentList);


        // ===================Duplicate Roll Number
        $student_student_roll_number=$StudentList->unique('student_roll_number')->pluck('student_roll_number')->filter();
        $duplicate_roll_array=[];
        foreach ($student_student_roll_number as $key => $value){
            $count_roll=$StudentList->where('student_roll_number', $value)->count();
            if($count_roll>1){
                $duplicate_roll_array[]=$StudentList->where('student_roll_number', $value);
            }
        }
        $duplicate_roll=collect($duplicate_roll_array)->collapse()->values();


        if(count($duplicate_roll)>0){

            return Response::json(['message' => 'Duplicate Roll Number is present!',
                'duplicate_roll_array'=>$duplicate_roll,
                'duplicate_registration_array'=>null,
                'duplicate_board_roll_array'=>null,
                'duplicate_board_registration_array'=>null,
                'mode' => 'Error'], 200);
        }


        // ==================Duplicate Registration No
        $student_student_registration_no=$StudentList->unique('registration_no')->pluck('registration_no')->filter();
        $duplicate_registration_no_array=[];
        foreach ($student_student_registration_no as $key => $value){
            $count_registration_no=$StudentList->where('registration_no', $value)->count();
            if($count_registration_no>1){
                $duplicate_registration_no_array[]=$StudentList->where('registration_no', $value);
            }
        }
        $duplicate_registration_no=collect($duplicate_registration_no_array)->collapse()->values();

        if(count($duplicate_registration_no)>0){

            return Response::json(['message' => 'Duplicate Registration Number is present!',
                'duplicate_roll_array'=>null,
                'duplicate_registration_array'=>$duplicate_registration_no,
                'duplicate_board_roll_array'=>null,
                'duplicate_board_registration_array'=>null,
                'mode' => 'Error'], 200);
        }



        // ==================Duplicate Board Roll No
        $student_student_board_roll_number=$StudentList->unique('board_roll_number')->pluck('board_roll_number')->filter();
        $duplicate_board_roll_number_array=[];
        foreach ($student_student_board_roll_number as $key => $value){
            $count_board_roll_number=$StudentList->where('board_roll_number', $value)->count();
            if($count_board_roll_number>1){
                $duplicate_board_roll_number_array[]=$StudentList->where('board_roll_number', $value);
            }
        }
        $duplicate_board_roll_number=collect($duplicate_board_roll_number_array)->collapse()->values();

        if(count($duplicate_board_roll_number)>0){

            return Response::json(['message' => 'Duplicate Board Roll Number is present!',
                'duplicate_roll_array'=>null,
                'duplicate_registration_array'=>null,
                'duplicate_board_roll_array'=>$duplicate_board_roll_number,
                'duplicate_board_registration_array'=>null,
                'mode' => 'Error'], 200);
        }



        // ==================Duplicate Board Registration No
        $student_student_board_registration_number=$StudentList->unique('board_registration_number')->pluck('board_registration_number')->filter();
        $duplicate_board_registration_number_array=[];
        foreach ($student_student_board_registration_number as $key => $value){
            $count_board_registration_number=$StudentList->where('board_registration_number', $value)->count();
            if($count_board_registration_number>1){
                $duplicate_board_registration_number_array[]=$StudentList->where('board_registration_number', $value);
            }
        }
        $duplicate_board_registration_number=collect($duplicate_board_registration_number_array)->collapse()->values();

        if(count($duplicate_board_registration_number)>0){

            return Response::json(['message' => 'Duplicate Board Registration Number is present!',
                'duplicate_roll_array'=>null,
                'duplicate_registration_array'=>null,
                'duplicate_board_roll_array'=>null,
                'duplicate_board_registration_array'=>$duplicate_board_registration_number,
                'mode' => 'Error'], 200);
        }



        $student_history_ids=$StudentList->pluck('id');

        $data = $request->all();

        $student_year_class = StudentHistory::
            select('id', 'student_roll_number', 'student_roll_number_prefix',
                'registration_no', 'board_registration_number', 'board_roll_number','academic_session_id')
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->get();

          //  dd($student_year_class);

        $student_current_history_llist=StudentHistory::whereIn('id', $student_history_ids)
            ->select('id', 'student_roll_number', 'student_roll_number_prefix',
                'registration_no', 'board_registration_number', 'board_roll_number','academic_session_id')
            ->get();

        $student_current_llist=StudentHistory::whereIn('id', $student_history_ids)
            ->select('id', 'student_roll_number', 'student_roll_number_prefix',
                'registration_no', 'board_registration_number', 'board_roll_number','academic_session_id')
            ->get();



        $duplicate_roll=[];
        $duplicate_reg=[];
        $duplicate_board_roll=[];
        $duplicate_board_reg=[];
        foreach ($StudentList as $key => $value){

            $find_data=$student_current_history_llist->where('id', $value['id'])->first();

            if($value['student_roll_number']!=$find_data->student_roll_number ||
                $value['registration_no']!=$find_data->registration_no ||
                $value['board_registration_number']!=$find_data->board_registration_number ||
                $value['board_roll_number']!=$find_data->board_roll_number ||
                $value['academic_session_id'] != $find_data->academic_session_id ||
                $value['student_roll_number_prefix'] != $find_data->student_roll_number_prefix ||
                $value['house_id']!=$find_data->house_id){


                $check_roll=$student_current_history_llist
                    ->where('id', '!=', $value['id'])
                    ->where('student_roll_number', $value['student_roll_number'])
                    ->first();

                if($value['registration_no']){
                    $check_reg=$student_current_llist
                        ->where('id', '!=', $value['id'])
                        ->where('registration_no', $value['registration_no'])
                        ->first();
                }else{
                    $check_reg=null;
                }

                if($value['board_roll_number']){
                    $check_board_roll= $student_year_class
                        ->where('id', '!=', $value['id'])
                        ->where('board_roll_number', $value['board_roll_number'])
                        ->first();
                }else{
                    $check_board_roll=null;
                }

                if($value['board_roll_number']){
                    $check_board_reg= $student_year_class
                        ->where('id', '!=', $value['id'])
                        ->where('board_registration_number', $value['board_registration_number'])
                        ->first();
                }else{
                    $check_board_reg=null;
                }

                if($value['student_roll_number_prefix']){
                    $check_student_roll_number_prefix = $student_year_class
                        ->where('id', '!=', $value['id'])
                        ->where('student_roll_number_prefix', $value['student_roll_number_prefix'])
                        ->first();
                }else{
                    $check_student_roll_number_prefix=null;
                }



                if(!$check_roll || !$check_reg || !$check_board_roll || !$check_board_reg || !$check_student_roll_number_prefix ){

                    StudentHistory::where('id', $value['id'])
                        ->update([
                            'student_roll_number_prefix'=>$value['student_roll_number_prefix'],
                            'student_roll_number'=>$value['student_roll_number'],
                            'registration_no'=>$value['registration_no'],
                            'board_registration_number'=>$value['board_registration_number'],
                            'board_roll_number'=>$value['board_roll_number'],
                            'academic_session_id'=>$value['academic_session_id'],
                            'house_id'=>$value['house_id'],
                        ]);


                    Student::where('id', $value['user_id'])
                    ->update([
                        'student_roll_number_prefix'=>$value['student_roll_number_prefix'],
                        'student_roll_number'=>$value['student_roll_number'],
                        'board_registration_number'=>$value['board_registration_number'],
                        'academic_session_id'=>$value['academic_session_id'],
                        'house_id'=>$value['house_id'],

                    ]);

            //=========


                }
                else{

                    if($check_roll){
                        $duplicate_roll[]=$check_roll;
                    }
                    else if($check_reg){
                        $duplicate_reg[]=$check_reg;
                    }
                    else if($check_board_roll){
                        $duplicate_board_roll[]=$check_board_roll;
                    }
                    else if($check_board_reg){
                        $duplicate_board_reg[]=$check_board_reg;
                    }
                }

            }

        }


        // if(count($duplicate_roll)>0){

        //     return Response::json(['message' => 'Duplicate Roll is present!',
        //         'duplicate_roll_array'=>$duplicate_roll,
        //         'duplicate_registration_array'=>null,
        //         'duplicate_board_roll_array'=>null,
        //         'duplicate_board_registration_array'=>null,
        //         'mode' => 'Error'], 200);
        // }

        // if(count($duplicate_reg)>0){

        //     return Response::json(['message' => 'Duplicate Reg. is present!',
        //         'duplicate_roll_array'=>null,
        //         'duplicate_registration_array'=>$duplicate_reg,
        //         'duplicate_board_roll_array'=>null,
        //         'duplicate_board_registration_array'=>null,
        //         'mode' => 'Error'], 200);
        // }

        // if(count($duplicate_board_roll)>0){

        //     return Response::json(['message' => 'Duplicate Board Roll is present!',
        //         'duplicate_roll_array'=>null,
        //         'duplicate_registration_array'=>null,
        //         'duplicate_board_roll_array'=>$duplicate_board_roll,
        //         'duplicate_board_registration_array'=>null,
        //         'mode' => 'Error'], 200);
        // }

        // if(count($duplicate_board_reg)>0){

        //     return Response::json(['message' => 'Duplicate Board Reg. is present!',
        //         'duplicate_roll_array'=>null,
        //         'duplicate_registration_array'=>null,
        //         'duplicate_board_roll_array'=>null,
        //         'duplicate_board_registration_array'=>$duplicate_board_reg,
        //         'mode' => 'Error'], 200);
        // }

        return Response::json(['message' => 'Successfully Updated',
            'mode' => 'success'], 200);
    }

    public function setUseridToStudentid(Request $request){
        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){
            return $valiedation;
        }

        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id', 'username');
        }])
            ->select('id', 'user_id', 'student_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();


        foreach ($student_list as $key => $value){

            $student= StudentHistory::where('id', $value->id)->first();

            $student->student_roll_number= $value->student->username;
            $student->student_roll_number_prefix= null;
            $student->save();
        }

        return Response::json(['message' => 'Successfully Student ID Set',
            'mode' => 'success'], 200);

    }


    //====================Personal Info=====================

    public function getStudentForPersonalInformationQuickUpdate(Request $request){

        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){
            return $valiedation;
        }

        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id', 'date_of_birth', 'religion_id', 'gender_id', 'blood_group_id');
        }])
            ->select('id', 'user_id', 'student_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();

        $siteInfoSettinglist = SiteInfoSetting::first();

        $genderlistsplite = explode(',', $siteInfoSettinglist->gender_ids);
        $genderlist = Gender::whereIn('id', $genderlistsplite)->get();

        $religionlistsplite = explode(',', $siteInfoSettinglist->religion_ids);
        $religionlist = Religion::whereIn('id', $religionlistsplite)->get();

        $bloodlist = BloodGroup::get();
      //  return $student_list;

        return response()->json(
            [
                'student_list'=>$student_list,
                'genderlist'=>$genderlist,
                'religionlist'=>$religionlist,
                'blood_group'=>$bloodlist,
             //   'house_list'=>$houselist,
            ]);

    }



    public function quickUpdatePersonalInformation(Request $request){

        $StudentList=collect($request->StudentList);

        $user_ids=$StudentList->pluck('user_id')->unique()->values();
        $user_list=Student::whereIn('id', $user_ids)->get();



        // $duplicate_data_array=[];
        // foreach ($StudentList as $key => $value){

        //     foreach ($StudentList as $keys => $values){

        //         if($value['student']['first_name']==$values['student']['first_name'] &&
        //             $value['student']['last_name']==$values['student']['last_name'] &&
        //             $value['student']['father_name']==$values['student']['father_name'] &&
        //             $value['student']['mother_name']==$values['student']['mother_name'] &&
        //             $value['student']['date_of_birth']==$values['student']['date_of_birth'] &&
        //             $value['id']!=$values['id']
        //         ){
        //             $duplicate_data_array[]=$value['id'];
        //         }
        //     }

        // }

        // if(count($duplicate_data_array)>0){

        //     return Response::json(['message' => 'Duplicate Data Present!',
        //         'duplicate_id_array'=>$duplicate_data_array,
        //         'mode' => 'Error'], 200);
        // }



        $duplicate_id=[];
        foreach ($request->StudentList as $key => $value){

            $find_student= $user_list->where('id', $value['user_id'])->first();

            $full_name_request = ($value['student']['first_name']) . ($value['student']['last_name'] ? $value['student']['last_name'] : '');

            if($find_student->first_name!=$value['student']['first_name'] ||
                $find_student->last_name!=$value['student']['last_name'] ||
                $find_student->father_name!=$value['student']['father_name'] ||
                $find_student->mother_name=$value['student']['mother_name'] ||
                $find_student->date_of_birth!=$value['student']['date_of_birth'] ||
                $find_student->gender_id!=$value['student']['gender_id'] ||
                $find_student->religion_id!=$value['student']['religion_id'] ||
                $find_student->blood_group_id!=$value['student']['blood_group_id'])
            {
          
                $getStudentSameBirthDate = Student::where('site_id', Session::get('SITE_ID'))
                    ->where('date_of_birth', $value['student']['date_of_birth'])
                    ->where('id', '!=', $value['user_id'])
                    ->select('id')
                    ->get();

                $student_birth_date_present_array=[];
                if (count($getStudentSameBirthDate) > 0) {

                    foreach ($getStudentSameBirthDate as $keys => $values) {

                       $countHistory=StudentHistory::where('user_id',$values->id)->where('status',true)->get()->count(); // temprary add

                        $full_name_with_out_space = ucwords(str_replace(' ', '', $values->full_name));
                        $father_name_with_out_space = ucwords(str_replace(' ', '', $values->father_name));
                        $mother_name_with_out_space = ucwords(str_replace(' ', '', $values->mother_name));


                        $present_full_name_with_out_space = ucwords(str_replace(' ', '', $full_name_request));
                        $present_father_name_with_out_space = ucwords(str_replace(' ', '', $value['student']['father_name']));
                        $present_mother_name_with_out_space = ucwords(str_replace(' ', '', $value['student']['mother_name']));

                        if (
                            $full_name_with_out_space == $present_full_name_with_out_space &&
                            $father_name_with_out_space == $present_father_name_with_out_space &&
                            $mother_name_with_out_space == $present_mother_name_with_out_space &&
                            $countHistory
                        )
                        {
                            $student_birth_date_present_array[] = 1;
                        }

                    }

                }


                $student_birth_date_present_count = collect($student_birth_date_present_array)->unique()->filter();
                if (count($student_birth_date_present_count) > 0) {
                    $student_birth_date_present = 1;
                } else {
                    $student_birth_date_present = 0;
                }


                if($student_birth_date_present==0){
                    $find_student->first_name=ucwords($value['student']['first_name']);
                    $find_student->last_name=ucwords($value['student']['last_name']);
                    $find_student->father_name=ucwords($value['student']['father_name']);
                    $find_student->mother_name=ucwords($value['student']['mother_name']);
                    $find_student->date_of_birth=$value['student']['date_of_birth'];
                    $find_student->gender_id=$value['student']['gender_id'];
                    $find_student->religion_id=$value['student']['religion_id'];
                    $find_student->blood_group_id=$value['student']['blood_group_id'];
                    //dd($find_student);
                    $find_student->save();
                }else if($student_birth_date_present==1){
                   // dd($value);
                    $duplicate_id[]=$value['id'];
                }

            }

        }

        if(count($duplicate_id)>0){
            return Response::json(['message' => 'Duplicate Data Present!',
                'duplicate_id_array'=>$duplicate_id,
                'mode' => 'Error'], 200);
        }

        return Response::json(['message' => 'Successfully Updated',
            'mode' => 'success'], 200);

    }

    //========================Contact Info============
    public function getStudentForContactsQuickUpdate(Request $request){

        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){

            return $valiedation;
        }

        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id', 'contact_number', 'father_contact_number',
                'mother_contact_number', 'birth_certificate_no', 'nid_number',
                'email', 'father_email', 'mother_email', 'father_nid', 'mother_nid');
        }])
            ->select('id', 'user_id', 'student_roll_number')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();

        return response()->json(['student_list'=>$student_list]);

    }


    public function quickUpdateContactsInformation(Request $request){

        $StudentList=collect($request->StudentList);

        $user_ids=$StudentList->pluck('user_id')->unique()->values();
        $user_list=Student::whereIn('id', $user_ids)->get();

        $duplicate_contact_number=[];
        $duplicate_birth_certificate=[];
        $duplicate_nid=[];
        $duplicate_email=[];

        foreach ($StudentList as $key => $value){

            $find_student= $user_list->where('id', $value['user_id'])->first();

            if($find_student->contact_number!=$value['student']['contact_number'] ||
                $find_student->father_contact_number!=$value['student']['father_contact_number'] ||
                $find_student->mother_contact_number!=$value['student']['mother_contact_number'] ||
                $find_student->birth_certificate_no=$value['student']['birth_certificate_no'] ||
                $find_student->nid_number!=$value['student']['nid_number'] ||
                $find_student->email!=$value['student']['email'] ||
                $find_student->father_email!=$value['student']['father_email'] ||
                $find_student->mother_email!=$value['student']['mother_email'] ||
                 $find_student->father_nid!=$value['student']['father_nid'] ||
                 $find_student->mother_nid!=$value['student']['mother_nid'])
            {

                if($value['student']['contact_number']){
                    $getStudentSameContactNumber = Student::where('site_id', Session::get('SITE_ID'))
                        ->where('contact_number', $value['student']['contact_number'])
                        ->where('id', '!=', $value['user_id'])
                        ->select('id')
                        ->get();

                }else{
                    $getStudentSameContactNumber=[];
                }

                if($value['student']['birth_certificate_no']){
                    $getStudentSameBirthCertificate = Student::where('site_id', Session::get('SITE_ID'))
                        ->where('birth_certificate_no', $value['student']['birth_certificate_no'])
                        ->where('id', '!=', $value['user_id'])
                        ->select('id')
                        ->get();
                }else{
                    $getStudentSameBirthCertificate=[];
                }

                if($value['student']['nid_number']){
                    $getStudentSameNid = Student::where('site_id', Session::get('SITE_ID'))
                        ->where('nid_number', $value['student']['nid_number'])
                        ->where('id', '!=', $value['user_id'])
                        ->select('id')
                        ->get();
                }else{
                    $getStudentSameNid=[];
                }

                if($value['student']['email']){
                    $getStudentSameEmail = Student::where('site_id', Session::get('SITE_ID'))
                        ->where('email', $value['student']['email'])
                        ->where('id', '!=', $value['user_id'])
                        ->select('id')
                        ->get();
                }else{
                    $getStudentSameEmail=[];
                }


                if(count($getStudentSameContactNumber)>0 || count($getStudentSameBirthCertificate)>0
                 ||count($getStudentSameNid)>0 || count($getStudentSameEmail)>0){

                    if(count($getStudentSameContactNumber)>0){
                        $duplicate_contact_number[]=$value;
                    }
                    if(count($getStudentSameBirthCertificate)>0){
                        $duplicate_birth_certificate[]=$value;
                    }
                    if(count($getStudentSameNid)>0){
                        $duplicate_nid[]=$value;
                    }
                    if(count($getStudentSameEmail)>0){
                        $duplicate_email[]=$value;
                    }


                }else{
                    $find_student->contact_number=$value['student']['contact_number'];
                    $find_student->father_contact_number=$value['student']['father_contact_number'];
                    $find_student->mother_contact_number=$value['student']['mother_contact_number'];
                    $find_student->birth_certificate_no=$value['student']['birth_certificate_no'];
                    $find_student->nid_number=$value['student']['nid_number'];
                    $find_student->email=$value['student']['email'];
                    $find_student->father_email=$value['student']['father_email'];
                    $find_student->mother_email=$value['student']['mother_email'];
                    $find_student->mother_nid=$value['student']['mother_nid'];
                    $find_student->father_nid=$value['student']['father_nid'];

                    $find_student->save();
                }

            }

        }

        if(count($duplicate_contact_number)>0 || count($duplicate_birth_certificate)>0
        || count($duplicate_nid)>0 || count($duplicate_email)>0){

            $content_name = count($duplicate_contact_number)>0?"Contact Number, ":"";
            $content_name .= count($duplicate_birth_certificate)>0?"Birth Certificate Number, ":"";
            $content_name .= count($duplicate_nid)>0?"NID, ":"";
            $content_name .= count($duplicate_email)>0?"E-mail":"";

            return Response::json(['message' => 'Duplicate '.$content_name.' Present!',
                'duplicate_contact_number'=>$duplicate_contact_number,
                'duplicate_birth_certificate'=>$duplicate_birth_certificate,
                'duplicate_nid'=>$duplicate_nid,
                'duplicate_email'=>$duplicate_email,
                'mode' => 'Error'], 200);
        }


        return Response::json(['message' => 'Successfully Updated',
            'mode' => 'success'], 200);


    }


    //======================Address=============

    public function getStudentForAddressQuickUpdate(Request $request){

        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){

            return $valiedation;
        }

        $student_list = StudentHistory::with(['student'=>function($query){
            $query->select('id', 'present_country_id', 'permanent_country_id',
                'present_division_id', 'permanent_division_id',
                'present_district_id', 'permanent_district_id',
                'present_thana_id', 'permanent_thana_id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();

            $country_list=Country::get();
            $division_list=Division::get();
            $district_list=District::get();
            $thana_list=Thana::get();

        return response()->json(
            [
                'student_list'=>$student_list,
                'country_list'=>$country_list,
                'division_list'=>$division_list,
                'district_list'=>$district_list,
                'thana_list'=>$thana_list,
            ]);
    }


    public function quickUpdateAddressInformation(Request $request){

        $StudentList=collect($request->StudentList);

        $user_ids=$StudentList->pluck('user_id')->unique()->values();
        $user_list=Student::whereIn('id', $user_ids)->get();

        foreach ($StudentList as $key => $value){

            $find_student= $user_list->where('id', $value['user_id'])->first();

            if($find_student->present_country_id!=$value['student']['present_country_id'] ||
                $find_student->present_division_id!=$value['student']['present_division_id'] ||
                $find_student->present_district_id!=$value['student']['present_district_id'] ||
                $find_student->present_thana_id=$value['student']['present_thana_id'] ||
                    $find_student->address!=$value['student']['address'] ||

                    $find_student->permanent_country_id!=$value['student']['permanent_country_id'] ||
                    $find_student->permanent_division_id!=$value['student']['permanent_division_id'] ||
                    $find_student->permanent_district_id!=$value['student']['permanent_district_id']||
                    $find_student->permanent_thana_id!=$value['student']['permanent_thana_id']||
                    $find_student->permanent_address!=$value['student']['permanent_address'])
            {

                $find_student->present_country_id=$value['student']['present_country_id'];
                $find_student->present_division_id=$value['student']['present_division_id'];
                $find_student->present_district_id=$value['student']['present_district_id'];
                $find_student->present_thana_id=$value['student']['present_thana_id'];
                $find_student->address=$value['student']['address'];

                $find_student->permanent_country_id=$value['student']['permanent_country_id'];
                $find_student->permanent_division_id=$value['student']['permanent_division_id'];
                $find_student->permanent_district_id=$value['student']['permanent_district_id'];
                $find_student->permanent_thana_id=$value['student']['permanent_thana_id'];
                $find_student->permanent_address=$value['student']['permanent_address'];

                $find_student->save();

            }
        }

        return Response::json(['message' => 'Successfully Updated',
            'mode' => 'success'], 200);

    }



    //======================Password Change & SMS =============

    public function getStudentForPasswordChangeQuickUpdate(Request $request){


        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){

            return $valiedation;
        }

        $StudentList = StudentHistory::with(['student'=>function($query){
            $query->select('id', 'username', 'contact_number');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();


        $student_list=[];
        $student_list_arr=Array();
        foreach ($StudentList as $key => $value){
            $student_list_arr['load_single_student_pass_change']=false;
            $student_list_arr['select_student_history_id']=false;

            $student_list[$key]=array_merge($student_list_arr, $value->toArray());
        }

        return response()->json(
            [
                'student_list'=>$student_list
            ]);

    }




//    public function quickSingleStudentPasswordChange(Request $request){
//
//        return $request;
//    }

    private function RandomString($length) {
        $keys = array_merge(range(0,9), range('A', 'Z'));

        $key = "";
        for($i=0; $i < $length; $i++) {
            $key .= $keys[mt_rand(0, count($keys) - 1)];
        }
        return $key;
    }

    public function quickStudentPasswordChange(Request $request){

        $studentList=collect($request->StudentList)->where('select_student_history_id', true);

        foreach ($studentList as $key => $value){





           //  dd($this->RandomString(6));

          //  $Password = mt_rand(10000, 99999);
            $Password = $this->RandomString(6);

            $student_detail=Student::where('id', $value['user_id'])->first();

            $student_detail
                ->update([
                    'password'=>$Password
                ]);

            $site_id=$student_detail->site_id;

            $site = SiteInfo::findOrFail($site_id);
            $url = config('app.url');

            // $sms_txt = 'Congrats, ' . $student_detail->full_name;
            // $sms_txt .= '[nl]' . $url;
            // $sms_txt .= '[nl]' . 'Username: ' . $student_detail->username;
            // $sms_txt .= '[nl]' . 'Pass: ' . $Password;
            // $sms_txt .= '[nl]' . 'Regards: ' . $site->site_name;

            $sms_txt = 'Congrats, ' . ucwords($student_detail->full_name);
            $sms_txt .= ', ' . $url;
            $sms_txt .= ', ' . 'Username: ' . $student_detail->username;
            $sms_txt .= ', ' . 'Pass: ' . $Password;
            $sms_txt .= ', ' . 'Thanks: ' . $site->translate('en')->short_name;

            $tt = $this->sendSms($site_id, [$student_detail->contact_number], $sms_txt);

        }

        return Response::json(['message' => 'Successfully Password Change & SMS Send to Student',
            'mode' => 'success'], 200);
    }



    //=================Subject===========

    public function getStudentForSubjectQuickUpdate(Request $request){

        $data=$request->all();
       // dd($data);

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){
            return $valiedation;
        }

        $StudentList = StudentHistory::with(['student'=>function($query){
            $query->select('id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix',
                'academic_subject_ids', 'religion_subject_id',
                'optional_subject_ids', 'compulsory_subject_ids','selective_compulsory_subject_ids', 'selective_markingless_subject_ids')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();
            //->first();


         //   return $StudentList;
              //// ==========
          //  $dept_id=$data['academic_department_id'];

            //  $limit_list22 = SiteSubjectConditionLimit::where('academic_class_id', $data['academic_class_id'])
            // ->where('academic_year_id', $data['academic_year_id'])
            // ->when($dept_id=$data['academic_department_id'] != 'null', function ($query) use ($dept_id) {
            //     return $query->where('academic_department_id', $dept_id);
            // })
            // ->where('status', true)
            // ->get();


            ///===== limit filtaring =====
            $limit_list = SiteSubjectConditionLimit::where('academic_class_id', $data['academic_class_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($dept_id=$data['academic_department_id'], function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            // ->when($group_id=$data['academic_group_id'] != 'null', function ($query) use ($group_id) {
            //     return $query->where('academic_group_id', $group_id);
            // })
            ->when($class_group_id=$data['academic_class_group_id'], function ($query) use ($class_group_id) {
                return $query->where('academic_class_group_id', $class_group_id);
            })
            ->where('status', true)
            ->get();



            $s_subjectCondition = SubjectCondition::where('condition_key','selectiveCompulsory')->first();
            $selective_copulsory = $limit_list->where('academic_subject_condition_id', $s_subjectCondition->id)->first();
           // $selective_copulsory_not_show_id['selective_copulsory_not_show_id'] = $selective_copulsory->not_show_academic_subject_ids;

           $selective_copulsory_not_show_ids_array = explode(',', $selective_copulsory->not_show_academic_subject_ids??0);


           $subject_list=$this->getClassGroupBaseSubjectList($request->academic_class_id,
           $request->academic_class_group_id,
           $request->academic_year_id,
           $request->academic_department_id);

           $religion_subject_list=$subject_list[0];
           $selective_compulsory_subject_list=$subject_list[1];
           $optional_subject_list=$subject_list[2];
           $selective_markingless_subject_list=$subject_list[3];
           $compulsory_subject_list=$subject_list[4];
           $slective_compulsory_subject_limit=$subject_list[5];
           $optional_subject_limit=$subject_list[6];

        $student_list_array=[];
        $student_list_arr=Array();
        foreach ($StudentList as $key => $value){
            //dd($value->compulsory_subject_ids[0][0]->id);


            $student_list_arr['academic_subject_ids']=$value->academic_subject_ids[0] ?? [];
            $student_list_arr['compulsory_subject_ids']=$value->compulsory_subject_ids[0] ?? [];

            $student_list_arr['selective_compulsory_subject_ids']=$value->selective_compulsory_subject_ids[0];

            $student_list_arr['optional_subject_ids']=$value->optional_subject_ids[0] ?? [];
            $student_list_arr['selective_markingless_subject_ids']=$value->selective_markingless_subject_ids[0] ?? [1];
            $student_list_arr['full_name']=$value->full_name;
            $student_list_arr['student_roll_number']=$value->student_full_roll_number ?? '';
            $student_list_arr['id']=$value['id'];

            $student_list_arr['religion_subject_id']=$value->religion_subject_id ?? 0;

            $student_list_array[$key]=$student_list_arr;
        }


        $student_list_ar=collect($student_list_array)->values();

            return response()->json(
            [
                'student_list'=>$student_list_ar,
                'religion_subject_list'=>$religion_subject_list,
                'selective_compulsory_subject_list'=>$selective_compulsory_subject_list,
                'optional_subject_list'=>$optional_subject_list,
                'selective_markingless_subject_list'=>$selective_markingless_subject_list,
                'compulsory_subject_list'=>$compulsory_subject_list,
                'slective_compulsory_subject_limit'=>$slective_compulsory_subject_limit,
                'optional_subject_limit'=>$optional_subject_limit,
                'selective_copulsory_not_show_ids_array'=>$selective_copulsory_not_show_ids_array,

            ]);

    }


    private function getClassGroupBaseSubjectList($classid, $groupid, $yearid, $department_id)
    {

        $dept_id = $department_id;

        $groupPresentCount = SiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->whereNotNull('academic_class_group_id')
            ->get()
            ->count();

        $siteClassBaseSubjectDetail = SubjectGroupConditionSetting::with(['academicSubject'])
            ->where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->where('status', true)
            ->get();

        $subjectCondition = SubjectCondition::get();

        $limit_list = SiteSubjectConditionLimit::where('academic_class_id', $classid)
            ->where('academic_year_id', $yearid)
            ->where('academic_class_group_id', $groupid)
            ->when($department_id != 'null', function ($query) use ($dept_id) {
                return $query->where('academic_department_id', $dept_id);
            })
            ->where('status', true)
            ->get();



        $classBaseOptionalSubjectIDList = [];
        $classBaseSelectiveCompulsorySubjectIDList = [];
        $classBaseReligionSubjectIDList = [];
        $classBaseMarkinglessSubjectIDList = [];
        $classBaseCompulsorySubjectIDList = [];
        $optional_subject_limit = 0;
        $compulsory_subject_limit = 0;
      //  $classBaseSelectiveCompulsorySubjectIDList = [];

        if (!$groupPresentCount && !$groupid) {

         //   $classBaseReligionSubjectIDList = [];
            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                // $OptionalSubjectId = SubjectCondition::whereIn('id', $academicOptionalSubjectConditionIds)
                //     ->where('condition_key', 'optional')
                //     ->first();
                // if ($OptionalSubjectId) {
                //     $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                // }

                // $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
                // $SelectiveCompulsorySubjectId = SubjectCondition::whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                //     ->where('condition_key', 'selectiveCompulsory')
                //     ->first();

                // if ($SelectiveCompulsorySubjectId) {
                //     $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                // }
                //====================== optional subject=======================
                //$academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $OptionalSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                    ->where('condition_key', 'optional')
                    ->first();
                if ($OptionalSubjectId) {
                    $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                }

                // ================selective-compulsory subject======================//
                $SelectiveCompulsorySubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                    ->where('condition_key', 'selectiveCompulsory')
                    ->first();

                if ($SelectiveCompulsorySubjectId) {
                    $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                }

                 // ================religion subject======================//
                 $religionSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                     ->where('condition_key', 'religion')
                     ->first();


                 if ($religionSubjectId) {
                     $classBaseReligionSubjectIDList[$key] = $value->academic_subject_id;
                 }

                 // ================selective-markingless subject======================//
                 $markinglessSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                    ->where('condition_key', 'selectiveMarkingless')
                    ->first();

                if ($markinglessSubjectId) {
                    $classBaseMarkinglessSubjectIDList[$key] = $value->academic_subject_id;
                }

                // ================compulsory subject======================//

                $compulsorySubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                ->where('condition_key', 'compulsory')
                ->first();

                if ($compulsorySubjectId) {
                    $classBaseCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                }

                // ===== optional subject limit ===
                $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $optional_id = $subjectCondition->where('condition_key', 'optional')
                    ->first();

                $optional_sub_limit = $limit_list->where('academic_subject_condition_id', $optional_id->id)
                    ->first();


                $OptionalSubjectId = $subjectCondition->whereIn('id', $academicOptionalSubjectConditionIds)
                    ->where('condition_key', 'optional')
                    ->first();

                if ($OptionalSubjectId) {
                    if ($optional_sub_limit) {
                        if ($optional_sub_limit->not_show_academic_subject_ids) {
                            $limited_subject_list = AcademicSubject::
                            whereIn('id', explode(',', $optional_sub_limit->not_show_academic_subject_ids))
                                ->get();

                            $check_limit_not_show = $limited_subject_list->where('id', $value->academic_subject_id)->first();
                            if (!$check_limit_not_show) {
                                $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            }

                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                        } else {
                            $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                        }
                    } else {
                        $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                    }

                }

                ///==
                   /// ====== compulsory subject limit ======
                   $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                   $selectiveCompulsory_id = $subjectCondition->where('condition_key', 'selectiveCompulsory')
                       ->first();

                   $selectiveCompulsory_sub_limit = $limit_list->where('academic_subject_condition_id', $selectiveCompulsory_id->id)
                       ->first();


                   $SelectiveCompulsorySubjectId = $subjectCondition->whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                       ->where('condition_key', 'selectiveCompulsory')
                       ->first();

                   if ($SelectiveCompulsorySubjectId) {
                       if ($selectiveCompulsory_sub_limit) {
                           if ($selectiveCompulsory_sub_limit->not_show_academic_subject_ids) {
                               $limited_compulsory_subject_list = AcademicSubject::
                               whereIn('id', explode(',', $selectiveCompulsory_sub_limit->not_show_academic_subject_ids))
                                   ->get();

                               $check_limit_not_show_compulsory = $limited_compulsory_subject_list->where('id', $value->academic_subject_id)->first();
                               if (!$check_limit_not_show_compulsory) {
                                   $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                               }

                               $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                           } else {
                               $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                               $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                           }
                       } else {
                           $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                       }

                   }
                   ///======

            };

        } else if ($groupPresentCount && $groupid) {

            foreach ($siteClassBaseSubjectDetail as $key => $value) {

                $academicClassGroupIds = explode(',', $value->academic_class_group_ids);
                $academicClassGroupPresent = array_keys($academicClassGroupIds, $groupid);

                if ($academicClassGroupPresent) {
                    $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                   //====================== optional subject=======================
                    $OptionalSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                        ->where('condition_key', 'optional')
                        ->first();
                    if ($OptionalSubjectId) {
                        $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                    }

                    // ================selective-compulsory subject======================//
                    $SelectiveCompulsorySubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                        ->where('condition_key', 'selectiveCompulsory')
                        ->first();

                    if ($SelectiveCompulsorySubjectId) {
                        $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                    }

                     // ================religion subject======================//
                     $religionSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                         ->where('condition_key', 'religion')
                         ->first();


                     if ($religionSubjectId) {
                         $classBaseReligionSubjectIDList[$key] = $value->academic_subject_id;
                     }

                     // ================selective-markingless subject======================//
                     $markinglessSubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                        ->where('condition_key', 'selectiveMarkingless')
                        ->first();

                    if ($markinglessSubjectId) {
                        $classBaseMarkinglessSubjectIDList[$key] = $value->academic_subject_id;
                    }

                    // ================compulsory subject======================//

                    $compulsorySubjectId = SubjectCondition::whereIn('id', $academicSubjectConditionIds)
                    ->where('condition_key', 'compulsory')
                    ->first();

                    if ($compulsorySubjectId) {
                        $classBaseCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                    }

                // ===== optional subject limit ===
                $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $optional_id = $subjectCondition->where('condition_key', 'optional')
                    ->first();

                $optional_sub_limit = $limit_list->where('academic_subject_condition_id', $optional_id->id)
                    ->first();


                $OptionalSubjectId = $subjectCondition->whereIn('id', $academicOptionalSubjectConditionIds)
                    ->where('condition_key', 'optional')
                    ->first();

                if ($OptionalSubjectId) {
                    if ($optional_sub_limit) {
                        if ($optional_sub_limit->not_show_academic_subject_ids) {
                            $limited_subject_list = AcademicSubject::
                            whereIn('id', explode(',', $optional_sub_limit->not_show_academic_subject_ids))
                                ->get();

                            $check_limit_not_show = $limited_subject_list->where('id', $value->academic_subject_id)->first();
                            if (!$check_limit_not_show) {
                                $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            }

                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                            $not_sowing_subject = $optional_sub_limit->not_show_academic_subject_ids ? $optional_sub_limit->not_show_academic_subject_ids : "";
                          //  $test = explode(',' $optional_sub_limit->not_show_academic_subject_ids);
                        } else {
                            $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                            $optional_subject_limit = $optional_sub_limit->limit_amount ? $optional_sub_limit->limit_amount : 0;
                            $not_sowing_subject = $optional_sub_limit->not_show_academic_subject_ids ? $optional_sub_limit->not_show_academic_subject_ids : "";
                        }
                    } else {//
                        $classBaseOptionalSubjectIDList[$key] = $value->academic_subject_id;
                    }

                }

                ///==

                      /// ====== compulsory subject limit ======
                   $academicSelectiveCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                   $selectiveCompulsory_id = $subjectCondition->where('condition_key', 'selectiveCompulsory')
                       ->first();

                   $selectiveCompulsory_sub_limit = $limit_list->where('academic_subject_condition_id', $selectiveCompulsory_id->id)
                       ->first();


                   $SelectiveCompulsorySubjectId = $subjectCondition->whereIn('id', $academicSelectiveCompulsorySubjectConditionIds)
                       ->where('condition_key', 'selectiveCompulsory')
                       ->first();

                   if ($SelectiveCompulsorySubjectId) {
                       if ($selectiveCompulsory_sub_limit) {
                           if ($selectiveCompulsory_sub_limit->not_show_academic_subject_ids) {
                               $limited_compulsory_subject_list = AcademicSubject::
                               whereIn('id', explode(',', $selectiveCompulsory_sub_limit->not_show_academic_subject_ids))
                               ->get();

                               $not_sowing_selective_Compulsory_subject = $selectiveCompulsory_sub_limit->not_show_academic_subject_ids ? $selectiveCompulsory_sub_limit->not_show_academic_subject_ids : "";

                               $check_limit_not_show_compulsory = $limited_compulsory_subject_list->where('id', $value->academic_subject_id)->first();
                               if (!$check_limit_not_show_compulsory) {
                                   $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                               }

                               $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                           } else {
                               $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                               $compulsory_subject_limit = $selectiveCompulsory_sub_limit->limit_amount ? $selectiveCompulsory_sub_limit->limit_amount : 0;
                           }
                       } else {
                           $classBaseSelectiveCompulsorySubjectIDList[$key] = $value->academic_subject_id;
                       }

                   }
                   ///======
                }

            };
        }

        $not_sowing_subject_array = explode(',', $not_sowing_subject??0);
        $not_sowing_Compulsory_subject_array = explode(',', $not_sowing_selective_Compulsory_subject??0);


        $OptionalSubjectList = AcademicSubject::whereIn('id', array_diff($classBaseOptionalSubjectIDList,$not_sowing_subject_array))->get();
        $SelectiveCompulsorySubjectList = AcademicSubject::whereIn('id', array_diff($classBaseSelectiveCompulsorySubjectIDList,$not_sowing_Compulsory_subject_array))->get();
        $religionSubjectList = AcademicSubject::whereIn('id', array_diff($classBaseReligionSubjectIDList,$not_sowing_subject_array))->withTranslation('bn')->get();
        $markinglessSubjectList = AcademicSubject::whereIn('id', array_diff($classBaseMarkinglessSubjectIDList,$not_sowing_subject_array))->withTranslation('bn')->get();
        $compulsorySubjectList = AcademicSubject::whereIn('id', $classBaseCompulsorySubjectIDList)->withTranslation('bn')->get();

        return [$religionSubjectList, $SelectiveCompulsorySubjectList, $OptionalSubjectList, $markinglessSubjectList, $compulsorySubjectList, $compulsory_subject_limit, $optional_subject_limit];
    }


    public function quickUpdateSubjectInformation(Request $request){

        $data = $request->all();
            $test = [];

            foreach ($request->StudentList as $key33 => $valuess){

            //$academicSubjectIDs = $this->academicSubjectList($request, $value);

              // academic all subject ids
              $Academic_subject_ids=[];


              if($valuess['academic_subject_ids']){
                    foreach($valuess['academic_subject_ids'] as $keys=>$value){
                        $Academic_subject_ids[$keys]=$value['id'];
                    }
              }

            // optional subject ids
            $Optional_subject_ids=[];
                foreach($valuess['optional_subject_ids'] as $keys=>$value){
                    $Optional_subject_ids[$keys]=$value['id'];
                }
            // selective compulsory subjects ids
                $selective_compulsory_subjects = [];
                     foreach($valuess['selective_compulsory_subject_ids'] as $keys=>$value){
                         $selective_compulsory_subjects[$keys]=$value['id'];
                     }
        //   dd($Optional_subject_ids);
            // selective markingless subject ids
             $Selective_markingless_subject_ids=[];

             if($valuess['selective_markingless_subject_ids']){
                   foreach($valuess['selective_markingless_subject_ids'] as $keys=>$value){
                       $Selective_markingless_subject_ids[$keys]=$value['id'];
                   }
             }

            // religion subject id

             $religion_subject_id=[];
             if($valuess['religion_subject_id']){
                  $religion_subject_id[]=$valuess['religion_subject_id'];

             }

            $religion_subject = [];
            if ($valuess['religion_subject_id']) {
                $religion_subject[] = $valuess['religion_subject_id'];
            }

            // ====== genaral subjects =====

            $subjectList = SubjectGroupConditionSetting::where('academic_class_id', $request->academic_class_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })

            ->where('status', true)
            ->get();


            $general_subject_ids = [];
            foreach ($subjectList as $key => $value) {

                $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

                if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                    $general_subject_ids[$key] = $value->academic_subject_id;
                }
            }

            //======

            // ===== compolsory subjects

            $Compulsory_subject_ids = [];
            if ($request->academic_class_group_id) {

                foreach ($subjectList as $key => $value) {

                    if ($value->academic_class_group_ids) {
                        $academicClassGroupIds = explode(',', $value->academic_class_group_ids);


                        if (in_array($request->academic_class_group_id, $academicClassGroupIds)) {
                            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);

                            $subjectCondition = SubjectCondition::where('condition_key', 'compulsory')->first();

                            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                                $Compulsory_subject_ids[$key] = $value->academic_subject_id;
                            }
                        }
                    }
                }
            }


            $Subjects = array_merge(
                $general_subject_ids,
                $Optional_subject_ids,
                $Compulsory_subject_ids,
                $Selective_markingless_subject_ids,
                $selective_compulsory_subjects,
           //     $Academic_subject_ids,
                $religion_subject_id,

            );



            $academicSubjectIds = (string)implode(',', $Subjects);

            $academicSubjectIdst = array_unique(explode(',', $academicSubjectIds));
            $finalAcademicSubjectIds = (string)implode(',', $academicSubjectIdst);
            $Optional_subject_ids=(string)implode(',', $Optional_subject_ids);
            $Compulsory_subject_ids=(string)implode(',', $Compulsory_subject_ids);
            $selective_compulsory_subject=(string)implode(',', $selective_compulsory_subjects);
            $Selective_markingless_subject_ids=(string)implode(',', $Selective_markingless_subject_ids);
          //  $Academic_subject_ids=(string)implode(',', $Academic_subject_ids);
            $religion_subject_id=(string)implode(',', $religion_subject_id);
           // dd($selective_compulsory_subjectsss);
            $StudentHistory = StudentHistory::find($valuess['id']);
           // dd($Optional_subject_ids);

            $StudentHistory->academic_subject_ids = $finalAcademicSubjectIds;
            $StudentHistory->religion_subject_id = $valuess['religion_subject_id'];
            $StudentHistory->compulsory_subject_ids = $Compulsory_subject_ids;
            $StudentHistory->selective_compulsory_subject_ids = $selective_compulsory_subject;
            $StudentHistory->optional_subject_ids = $Optional_subject_ids;
            $StudentHistory->selective_markingless_subject_ids = $Selective_markingless_subject_ids;
            $StudentHistory->selective_markingless_subject_ids = $Selective_markingless_subject_ids;

            $StudentHistory->save();
            $StudentHistory->subjects()->sync(explode(',', $finalAcademicSubjectIds));

         //   $StudentHistory22 = StudentHistory::find($valuess['id']);
        //    dd($valuess['id']);
           // user table update
            $st_History = StudentHistory::findOrFail($valuess['id']);
            $student = Student::where('id', $st_History->user_id)->first();


            $student->academic_subject_ids = $finalAcademicSubjectIds;
            $student->religion_subject_id = $valuess['religion_subject_id'];
            $student->compulsory_subject_ids = $Compulsory_subject_ids;
            $student->selective_compulsory_subject_ids = $selective_compulsory_subject;
            $student->optional_subject_ids = $Optional_subject_ids;
            $student->selective_markingless_subject_ids = $Selective_markingless_subject_ids;
            $student->save();

            $student->subjects()->sync(explode(',', $finalAcademicSubjectIds));

            ////

        }

        return Response::json(['message' => 'Successfully Student Subject Update.',
            'mode' => 'success'], 200);

    }


    //==================Section===========

    public function getStudentForSectionQuickUpdate(Request $request){


        $data=$request->all();

//        $valiedation=$this->classGroupSectionValidation($request);
//        if($valiedation){
//
//            return $valiedation;
//        }



        $StudentList = StudentHistory::with(['student'=>function($query){
            $query->select('id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix',
                'academic_section_id')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();



        $student_list_array=[];
        $student_list_arr=Array();
        foreach ($StudentList as $key => $value){

            $student_list_arr['full_name']=$value->full_name;
            $student_list_arr['student_full_roll_number']=$value->student_full_roll_number ?? '';
            $student_list_arr['student_roll_number']=$value->student_roll_number ?? '';
            $student_list_arr['id']=$value['id'];

            $student_list_arr['academic_section_id']=$value->academic_section_id ?? null;

            $student_list_array[$key]=$student_list_arr;
        }

        $student_list=collect($student_list_array)->values();



        $section_list_detail=SiteShiftClassGroupSectionSetting::
            when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->first();


        if($section_list_detail->academic_class_group_id && !$data['academic_class_group_id']){
            $site_info_list=SiteInfoSetting::select('id', 'academic_section_ids')->first();
            $section_list=AcademicSection::whereIn('id', explode(',', $site_info_list->academic_section_ids))->get();
        }
        else{
            $section_list=AcademicSection::whereIn('id', explode(',', $section_list_detail->academic_section_ids))->get();
        }

        return response()->json(
            [
                'student_list'=>$student_list,
                'section_list'=>$section_list
            ]);
    }



    public function quickUpdateSectionInformation(Request $request){

        foreach ($request->StudentList as $key => $value){

            $student = StudentHistory::where('id', $value['id'])->first();

            if($student->academic_section_id != $value['academic_section_id']){

                $student->academic_section_id = $value['academic_section_id'];
                $student->save();
            }


        }

        return Response::json(['message' => 'Successfully Student Section Update.',
            'mode' => 'success'], 200);


    }



    //===============Shift & Group ===========

    public function getStudentForShiftGroupQuickUpdate(Request $request){

        $data=$request->all();

//        $valiedation=$this->classGroupSectionValidation($request);
//        if($valiedation){
//
//            return $valiedation;
//        }



        $StudentList = StudentHistory::with(['student'=>function($query){
            $query->select('id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix',
                'academic_shift_id', 'academic_class_group_id')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();

        $student_list_array=[];
        $student_list_arr=Array();
        foreach ($StudentList as $key => $value){

            $student_list_arr['full_name']=$value->full_name;
            $student_list_arr['student_full_roll_number']=$value->student_full_roll_number ?? '';
            $student_list_arr['student_roll_number']=$value->student_roll_number ?? '';
            $student_list_arr['id']=$value['id'];

            $student_list_arr['academic_class_group_id']=$value->academic_class_group_id ?? null;
            $student_list_arr['academic_shift_id']=$value->academic_shift_id ?? null;

            $student_list_array[$key]=$student_list_arr;
        }

        $student_list=collect($student_list_array)->values();



        $shift_list_ids=SiteShiftClassGroupSectionSetting::
            when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('academic_shift_id')
            ->unique();

        $group_list_ids=SiteShiftClassGroupSectionSetting::
            where('academic_class_id', $data['academic_class_id'])
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->pluck('academic_class_group_id')
            ->unique();

        $shift_list=AcademicShift::whereIn('id', $shift_list_ids)->get();
        $class_group_list=AcademicClassGroup::whereIn('id', $group_list_ids)->get();

        return response()->json(
            [
                'student_list'=>$student_list,
                'shift_list'=>$shift_list,
                'class_group_list'=>$class_group_list,

            ]);

    }

    public function quickUpdateShiftGroupInformation(Request $request){

        foreach ($request->StudentList as $key => $value){

            $student = StudentHistory::where('id', $value['id'])->first();

            if($value['academic_shift_id']){
                $student->academic_shift_id = $value['academic_shift_id'];
            }

            if($value['academic_class_group_id']){
                $student->academic_class_group_id = $value['academic_class_group_id'];
            }
            else{
                $student->academic_class_group_id = null;
            }

            $student->save();

        }

        return Response::json(['message' => 'Successfully Student Shift & Group Update.',
            'mode' => 'success'], 200);
    }


    //=====================Image=============

    public function getStudentForImageQuickUpdate(Request $request){

        $data=$request->all();

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){

            return $valiedation;
        }

        $student_list = StudentHistory::with(['student'=>function($query){
            $query->with(['latestPhoto']);
            $query->select('id');
        }])
            ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix')
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_department_id', 'ASC')
            ->get();
           // dd($student_list->user_id);

               $student_list_array=[];
        $student_list_arr=Array();
        foreach ($student_list as $key => $value){

            $student_list_arr['file']=null;
            $student_list_arr['user_id']=$value->user_id;
            $student_list_arr['student']=$value->student;
            $student_list_arr['full_name']=$value->full_name;
            $student_list_arr['student_full_roll_number']=$value->student_full_roll_number ?? '';
            $student_list_arr['student_roll_number']=$value->student_roll_number ?? '';
            $student_list_arr['id']=$value['id'];

            $student_list_arr['academic_class_group_id']=$value->academic_class_group_id ?? null;
            $student_list_arr['academic_shift_id']=$value->academic_shift_id ?? null;

            $student_list_array[$key]=$student_list_arr;
        }

        $student_list=collect($student_list_array)->values();


        return response()->json(
            [
                'student_list'=>$student_list,
            ]);

    }

    public function quickUpdateSingleImage(Request $request){

           $data = $request->all();
           $user_id = $data['student_details']['user_id'];
           $image_file = $data['student_details']['file'];

          if($image_file){
            $name = time() . '.' . explode('/', explode(':', substr($image_file, 0, strpos($image_file, ';')))[1])[1];
            $fileName = $name;

            Image::make($image_file)->resize(440, 442)->save(public_path('uploads/') . $name);
            $image_path = '/uploads/'.$name;

            $photo = new Photo();
            $photo->user_id = $user_id;
            $photo->imageable_id = $user_id;
            $photo->imageable_type = 'App\Models\Site\Student\Student';
            $photo->name = $fileName;
            $photo->path = $image_path;
            $photo->save();

          }else{
            $student = Student::select('id','gender_id')->with(['latestPhoto'])->where('id',$user_id)->first();

            if(!$student->latestPhoto){
                $photo = new Photo();
                $photo->user_id = $user_id;
                $photo->imageable_id = $user_id;
                $photo->imageable_type = 'App\Models\Site\Student\Student';
                if($student->gender_id==30){
                    $photo->name = 'student-boy.png';
                    $photo->path = '/uploads/student-boy.png';
                }else{
                    $photo->name = 'student-girl.png';
                    $photo->path = '/uploads/student-girl.png';
                }
                // $photo->name = 'image-not.png';
                // $photo->path =  $image_path = 'uploads/image-not.png';
                $photo->save();
            }

          }

        return Response::json(['message' => 'Successfully Student image Update.',
            'mode' => 'success'], 200);
    }

    public function quickUpdateAllImage(Request $request){

        $data = $request->all();

       // dd($data['StudentList']);

        foreach($data['StudentList'] as $key=>$item){
            $user_id = $item['user_id'];
            $image_file = $item['file'];


       if($image_file){
        //  $name = time() . '.' . explode('/', explode(':', substr($image_file, 0, strpos($image_file, ';')))[1])[1];
        //  $fileName = $name;

        //  Image::make($image_file)->resize(440, 442)->save(public_path('uploads/') . $name);
        //  $image_path = '/uploads/'.$name;

        //  $photo = new Photo();
        //  $photo->user_id = $user_id;
        //  $photo->imageable_id = $user_id;
        //  $photo->imageable_type = 'App\Models\Site\Student\Student';
        //  $photo->name = $fileName;
        //  $photo->path = $image_path;
        //  $photo->save();

       }else{
        $student = Student::select('id','gender_id')->with(['latestPhoto'])->where('id',$user_id)->first();

         if(!$student->latestPhoto){
             $photo = new Photo();
             $photo->user_id = $user_id;
             $photo->imageable_id = $user_id;
             $photo->imageable_type = 'App\Models\Site\Student\Student';
             if($student->gender_id==30){
                $photo->name = 'student-boy.png';
                $photo->path = '/uploads/student-boy.png';
            }else{
                $photo->name = 'student-girl.png';
                $photo->path = '/uploads/student-girl.png';
            }
            //  $photo->name = 'image-not.png';
            //  $photo->path =  $image_path = 'uploads/image-not.png';
             $photo->save();
         }

       }
    }

     return Response::json(['message' => 'Successfully Students Image Update.',
         'mode' => 'success'], 200);
 }

}
